#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <pthread.h>
#include <stdarg.h>
#include <mysql/errmsg.h>
#include <mysql.h>
#include <unistd.h>

volatile unsigned int g_ThreadsCounter=0; /* при старте потока увеличится на единицу, при окончании - уменьшится, программа не закончит, пока счетчик не уйдет в 0 */
volatile unsigned char g_AllThreadsStarted=0; /* Пока данная переменная не станет равной 100 программа не будет ждать завершения */
pthread_mutex_t g_Mutex=PTHREAD_MUTEX_INITIALIZER; /* для защиты g_ThreadsCounter */

#define INC_COUNTER() do { pthread_mutex_lock(&g_Mutex); ++g_ThreadsCounter;  pthread_mutex_unlock(&g_Mutex); } while(0)
#define DEC_COUNTER() do { pthread_mutex_lock(&g_Mutex); --g_ThreadsCounter;  pthread_mutex_unlock(&g_Mutex); } while(0)

void WriteLog_r(const char *,...); /* Многопоточная версия лога на консоль */
int GetMainThreadMysqlValue(); /* "Доказательство" того, что в основном потоке все замечательно */
void* ThreadFunc(void*);

int main()
{
    register unsigned int i;
    
    unsigned int nWorkingThreads;
    
    //GetMainThreadMysqlValue();
    
    for (i=0; i<100; ++i)
    {
	pthread_t thread_id;
	pthread_attr_t attrs;
	int flgThreadError=0;

	pthread_mutex_lock(&g_Mutex);
	do
	{
	    int nThreadStartResult;
	    
	    /* инициализация атрибутов потока */
	    if (0!=pthread_attr_init(&attrs))
	    {
		/* WriteLog_r("%s","Main thread: Error: cannot initialize pthread attributes."); */
		flgThreadError=1;
		break;
	    };
	    
	    /* установка атрибута "отсоединенный (не надо джоинить)" */
	    if (0!=pthread_attr_setdetachstate(&attrs,PTHREAD_CREATE_DETACHED))
	    {
		WriteLog_r("%s","Main thread: Error in setting pthread attributes.");
		flgThreadError=1;
		break;
	    }
	    
	    /* Запускаем поток */
	    nThreadStartResult=pthread_create(&thread_id,&attrs,ThreadFunc,NULL); 
	    if (0!=nThreadStartResult)
	    {
		WriteLog_r("Main thread: Error in a call of function pthread_create (returned %d).",nThreadStartResult);
		flgThreadError=1;
		break;
	    }
	    
	    WriteLog_r("Main thread: Thread with id %u created.",thread_id);
	}
	while (0);
	if (flgThreadError)
	{
	    WriteLog_r("Main thread: Error in starting for writing in database thread!");
	}
	pthread_mutex_unlock(&g_Mutex);
    }
    
    while (100!=g_AllThreadsStarted) // Подождем, пока все потоки запустятся
    {
	WriteLog_r("Waiting... Count of Started threads is %u",g_AllThreadsStarted);
	sleep(1);
    }
    
    WriteLog_r("Main thread: Releasying assigned resources...");
    
    do
    {
	pthread_mutex_lock(&g_Mutex);
	nWorkingThreads=g_ThreadsCounter;
	pthread_mutex_unlock(&g_Mutex);
	
	if (!nWorkingThreads)
	    break;
	
	WriteLog_r("Main thread: Waiting threads finish (current count - %u)...",nWorkingThreads);
	sleep(1);
    }
    while (1); /* пока хоть один поток работает, надо дожидаться */
    
    WriteLog_r("Main thread: Assigned resources released...");
    WriteLog_r("Main thread: Exiting program...");
    
    return 0;
}


void WriteLog_r(const char *s,...) /* Многопоточная версия лога на консоль */
{
    static pthread_mutex_t job_mutex=PTHREAD_MUTEX_INITIALIZER;
    va_list paramList;
    
    pthread_mutex_lock(&job_mutex);
    va_start(paramList,s);
    vprintf(s,paramList);
    va_end(paramList);
    printf("\n\n");
    pthread_mutex_unlock(&job_mutex);
}

int GetMainThreadMysqlValue()
{
    MYSQL mysql;
    mysql_init(&mysql);
    
    if (!mysql_real_connect(&mysql,"IP_OF_MYSQL_SERVER","LOGIN","PASSWORD","test",3306,NULL,0))
    {
	WriteLog_r("Main thread: Unable to connect to mysql.\nmysql_error: %s\nmysql_errno: %u\nerrno: %u",mysql_error(&mysql),mysql_errno(&mysql),errno);
	mysql_close(&mysql);
	return 0;
    }
    WriteLog_r("%s","Main thread: Connecting to mysql was successfull.");
    
    const char* pszQuery="select 2+2";
    if (mysql_query(&mysql,pszQuery))
    {
	WriteLog_r("Main thread: query: %s\nmysql_error: %s\nmysql_errno: %u\nerrno: %u",pszQuery,mysql_error(&mysql),mysql_errno(&mysql),errno);
	mysql_close(&mysql);
	return 0;
    }
    
    MYSQL_RES *res;
    res=mysql_store_result(&mysql);
    
    my_ulonglong llCount;
    llCount=mysql_num_rows(res);
    if (!llCount)
    {
	WriteLog_r("Main thread: Empty result of Query\n%s",pszQuery);
	mysql_free_result(res);
	mysql_close(&mysql);
	return 0;
    }

    MYSQL_ROW row;    
    row=mysql_fetch_row(res);
    
    if (row)
	WriteLog_r("Main thread: query result: %s",row[0]);
    else
	WriteLog_r("%s","Main thread: query result: NULL");
    
    mysql_free_result(res);
    
    mysql_close(&mysql);
    
    return 1;
}

void* ThreadFunc(void* unused)
{
    unused=unused; /* Знаю, бред, но иначе идёт ругань: error: parameter name omitted, а если не использовать unused, то warning: unused parameter ‘unused’ */

    WriteLog_r("Additional thread: Starting thread with id %u.",pthread_self());
    
    ++g_AllThreadsStarted;
    
    INC_COUNTER();
    
    MYSQL mysql;
    mysql_init(&mysql);
    WriteLog_r("%s","Additional thread: After mysql_init...");
    
    do
    {
	unsigned int timeout = 60;
	if (mysql_options(&mysql,MYSQL_OPT_CONNECT_TIMEOUT,(const char*)&timeout))
	{
	    WriteLog_r("Additional thread: Error: Unpossible to set connection timeout\n%s\nmysql_errno: %u\nerrno: %u\n",mysql_error(&mysql),mysql_errno(&mysql),errno);
    	    WriteLog_r("%s","Additional thread: Trying again...");
    	    continue;
    	}
    	WriteLog_r("%s","Additional thread: After myql_options (MYSQL_OPT_CONNECT_TIMEOUT)...");
    	
    	if (!mysql_real_connect(&mysql,"IP_OF_MYSQL_SERVER","LOGIN","PASSWORD","test",3306,NULL,0))
    	{
    	    WriteLog_r("Additional thread: Unable to connect to mysql server.\n%s\nmysql_errno(): %u\nerrno: %u",mysql_error(&mysql),mysql_errno(&mysql),errno);
    	    if (CR_CONN_HOST_ERROR==mysql_errno(&mysql))
    	    {
    		WriteLog_r("%s","Additional thread: Trying again...");
    		continue;
    	    }
    	    if (CR_SERVER_LOST==mysql_errno(&mysql))
    	    {
    		WriteLog_r("%s","Additional thread: Trying again...");    	    
    		continue;
    	    }
    	    
    	    /* Выходим из потока, подключение не проходит */
    	    
    	    WriteLog_r("%s","Additional thread: Now thread will be finished.");
    	    	
    	    DEC_COUNTER();
		
	    mysql_close(&mysql);
	    WriteLog_r("Additional thread: Thread with id %u finished...",pthread_self());
	    return NULL;
	} /* if (NULL==mysql_real_connect...) */
	    
	WriteLog_r("%s","Additional thread: After myql_real_connect...");
	    
	const char* pszQuery="select 2+2";
	if (mysql_query(&mysql,pszQuery))
	{
	    WriteLog_r("Additional thread: mysql_query(\n\n%s\n\n) \n\n failed with message\n%s\nmysql_errno=%u\nerrno=%u",pszQuery,mysql_error(&mysql),mysql_errno(&mysql),errno);
	    
	    if (CR_CONN_HOST_ERROR==mysql_errno(&mysql))
	    {
		WriteLog_r("%s","Additional thread: Trying again...");
		mysql_close(&mysql);
		continue;
	    }
	    if (CR_SERVER_LOST==mysql_errno(&mysql))
	    {
		WriteLog_r("%s","Additional thread: Trying again...");
		mysql_close(&mysql);
		continue;
	    }
	    
	    /* Выходим из потока, запрос не проходит */
    	    
    	    WriteLog_r("%s","Additional thread: Now thread will be finished.");
    	    
	    DEC_COUNTER();		
	    
	    mysql_close(&mysql);
	    WriteLog_r("Additional thread: Thread with id %u finished...",pthread_self());
	    return NULL;
	} /* if (mysql_query) */
	    
	WriteLog_r("%s","Additional thread: after query...");
	
	MYSQL_RES *res;
	res=mysql_store_result(&mysql);
	
	my_ulonglong llCount=mysql_num_rows(res);
	
	if (!llCount)
	{
	    WriteLog_r("Additional thread: Empty result of Query\n%s",pszQuery);
	    mysql_free_result(res);
	    
	    WriteLog_r("%s","Additional thread: Now thread will be finished.");
    	    
	    DEC_COUNTER();		
	    
	    mysql_close(&mysql);
	    WriteLog_r("Additional thread: Thread with id %u finished...",pthread_self());
	    return NULL;
	}

	MYSQL_ROW row;    
	row=mysql_fetch_row(res);
    
	if (row)
	    WriteLog_r("Main thread: query result: %s",row[0]);
	else
	    WriteLog_r("%s","Main thread: query result: NULL");
    
	mysql_free_result(res);
	
	mysql_close(&mysql);
	break; /* соединение установлено, запрос выполнен */
    } 
    while (1);
    
    DEC_COUNTER();
    
    WriteLog_r("Additional thread: Thread with id %u finished...",pthread_self());
            
    return NULL;
}
