<?php

if ( ! defined( 'DATALIFEENGINE' ) ) {
	die( 'Hacking attempt!' );
}
define( 'DLEMOVIE_DIR', ENGINE_DIR . '/modules/dlemovie' );

include ENGINE_DIR . '/data/dlemovie.php';
include DLEMOVIE_DIR . '/classes/dlemovie.class.php';

$dlemovie = new DleMovie( $db, $dlemovie_config, $config );
$dlemovie->lang = $dlemovie_lang;
$ogmetadata = '';

$_content = $dlemovie->incCssAndJs( true, false );
$_title = '';
$_action = $_REQUEST['act'];
$group = $is_logged ? $member_id['user_group'] : 5;

if ( $dlemovie->config['offline'] == 'yes' ) {
	$_offline = true;
	if ( $is_logged and $group == 1 ) {
		$_title .= ' ' . $dlemovie->lang['offline_mode'];
		$_offline = false;
	} else {
		$tpl->load_template( 'dlemovie/main.tpl' );
		$tpl->set( '{description}', $_title );
		$tpl->set( '{content}', $_content . $dlemovie->infoBox( $dlemovie->config['offline_reason'], true ) );
		$tpl->compile( 'content' );
	}
}

$hometype = $dlemovie->config['hometype'];
if ( $_COOKIE['dlemovie_type'] == 'video' or $_COOKIE['dlemovie_type'] == 'category' ) $dlemovie->config['hometype'] = $_COOKIE['dlemovie_type'];
if ( $_REQUEST['view'] == 'all' or $_REQUEST['view'] == 'video' or $_REQUEST['view'] == 'category' ) {
	$dlemovie->config['hometype'] = str_replace( 'all', 'video', $_REQUEST['view'] );
	set_cookie( 'dlemovie_type', $dlemovie->config['hometype'], false );
}
if ( $dlemovie->config['hometype'] == 'category' and $dlemovie->config['categories'] == 'no' ) $dlemovie->config['hometype'] = 'video';

$tpl->load_template( 'dlemovie/navigation.tpl' );
$tpl->set( '{videos}', $dlemovie->parseUrl( '?do=video&view=all', 'video/all/' ) );
$tpl->set( '{category}', $dlemovie->parseUrl( '?do=video&view=category', 'video/category/' ) );
$tpl->set( '{top-view}', $dlemovie->parseUrl( '?do=video&act=top&type=view', 'video/top/view/' ) );
$tpl->set( '{top-rating}', $dlemovie->parseUrl( '?do=video&act=top&type=rating', 'video/top/rating/' ) );
$tpl->set( '{top-new}', $dlemovie->parseUrl( '?do=video&act=top&type=new', 'video/top/new/' ) );
$tpl->set( '{search}', $dlemovie->parseUrl( '?do=video&act=search', 'video/search/' ) );
$tpl->set( '{upload}', $dlemovie->parseUrl( '?do=video&act=upload', 'video/upload/' ) );

if ( $group != 5 and $user_group[$group]['dm_upload_url'] == 1 ) {
	$tpl->set_block( "'\\[upload\\](.*?)\\[/upload\\]'si", "\\1" );
} else {
	$tpl->set_block( "'\\[upload\\](.*?)\\[/upload\\]'si", "" );
}
if ( $dlemovie->config['categories'] == 'yes' ) {
	$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "\\1" );
} else {
	$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "" );
}

$tpl->compile( 'dlemovie-navigation' );
$_content .= $tpl->result['dlemovie-navigation'];

$dlemovie->category = get_vars( 'dlemovie-category' );
if ( ! is_array( $dlemovie->category ) ) {
	$dlemovie->category = array( );
	$db->query( "SELECT * FROM " . PREFIX . "_dm_category ORDER BY posi ASC" );
	while ( $row = $db->get_row( ) ) {
		$dlemovie->category[$row['id']] = array( );
		foreach ( $row as $key => $value ) $dlemovie->category[$row['id']][$key] = stripslashes( $value );
	}
	set_vars( 'dlemovie-category', $dlemovie->category );
	$db->free( );
}

switch ( $_action ) {
	default :
		$page = intval( $_REQUEST['page'] );
		$page = ( $page <= 0 ) ? 1 : $page;
		$i = 0;
		
		$_title = $dlemovie->lang['title_'.$dlemovie->config['hometype']];
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->speedBar( $dlemovie->config['mainname'], ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video', 'video/' ) : false ) );
		
		if ( $dlemovie->config['hometype'] == 'video' ) {
			$limit_topage = $dlemovie->config['video_topage'];
			$max = ( integer ) $dlemovie->config['video_toline'];
			$limit = ( $page * $limit_topage ) - $limit_topage;
			if ( $dlemovie->config['video_sort'] == 2 ) $sort_sql = 'title DESC';
			elseif ( $dlemovie->config['video_sort'] == 3 ) $sort_sql = 'date ASC';
			elseif ( $dlemovie->config['video_sort'] == 4 ) $sort_sql = 'date DESC';
			elseif ( $dlemovie->config['video_sort'] == 5 ) $sort_sql = 'views ASC';
			elseif ( $dlemovie->config['video_sort'] == 6 ) $sort_sql = 'views DESC';
			elseif ( $dlemovie->config['video_sort'] == 7 ) $sort_sql = 'rating ASC';
			elseif ( $dlemovie->config['video_sort'] == 8 ) $sort_sql = 'rating DESC';
			else $sort_sql = 'title ASC';
			$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_videos.approved = '1' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
			$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_videos WHERE approved = '1'" );
		} elseif ( $dlemovie->config['hometype'] == 'category' ) {
			$limit_topage = $dlemovie->config['category_topage'];
			$max = ( integer ) $dlemovie->config['category_toline'];
			$limit = ( $page * $limit_topage ) - $limit_topage;
			if ( $dlemovie->config['category_sort'] == 2 ) $sort_sql = 'title DESC';
			elseif ( $dlemovie->config['category_sort'] == 3 ) $sort_sql = 'videos ASC';
			elseif ( $dlemovie->config['category_sort'] == 4 ) $sort_sql = 'videos DESC';
			elseif ( $dlemovie->config['category_sort'] == 5 ) $sort_sql = 'posi ASC';
			elseif ( $dlemovie->config['category_sort'] == 6 ) $sort_sql = 'posi DESC';
			else $sort_sql = 'title ASC';
			$sql = $db->query( "SELECT id, name, title, preview, videos, previewup FROM " . PREFIX . "_dm_category WHERE parentid = '0' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
			$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_category WHERE parentid = '0'" );
		}
		
		$width = round( 100 / $max, 0 ) . '%';
		$count = $sql_total['count'];
		$total_pages = ceil( $count / $limit_topage );
		
		if ( $dlemovie->config['hometype'] == 'video' ) {
			if ( $db->num_rows( $sql ) > 0 ) {
				$favorite = explode( ',', $member_id['dm_favorite_video'] );
				$tpl->result['dlemovie-videos'] = '';
				while ( $row = $db->get_row( $sql ) ) {
					if ( $i == $max ) {
						$tpl->result['dlemovie-videos'] .= '</tr><tr><td colspan="' . $max . '" class="dlemovie-content-break"></td></tr><tr>';
						$i = 1;
					} else $i ++;
					$videocategory = $dlemovie->categoryInfo( $row['category'] );
					$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
					
					$tpl->load_template( 'dlemovie/block-video.tpl' );
					$tpl->set( '{table-width}', $width );
					$tpl->set( '{video-id}', $row['id'] );
					$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
					$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
					$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
					$tpl->set( '{category-id}', $row['category'] );
					$tpl->set( '{category-name}', $videocategory['title'] );
					$tpl->set( '{category-link}', $videocategory['link'] );
					$tpl->set( '{member-id}', $row['member'] );
					$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
					$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
					$tpl->set( '{views}', intval( $row['views'] ) );
					$tpl->set( '{rating}', intval( $row['rating'] ) );
					$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
					
					if ( $dlemovie->config['categories'] == 'yes' ) {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					} else {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					}
					if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
					} else {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
					}
					if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
						if ( in_array( $row['id'], $favorite ) ) {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						} else {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
						}
					} else {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
					}
					if ( $row['category'] == 0 ) {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
					} else {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
					}
					if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
						$tpl->set( '{comments}', intval( $row['comments'] ) );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
					} else {
						$tpl->set( '{comments}', '' );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
					}
					
					$tpl->compile( 'dlemovie-videos' );
				}
				$_content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-videos'] . '</tr></table>';
			} else $_content .= $dlemovie->infoBox( $dlemovie->lang['not_videos'] );
		} elseif ( $dlemovie->config['hometype'] == 'category' ) {
			if ( $db->num_rows( $sql ) > 0 ) {
				$tpl->result['dlemovie-categories'] = '';
				while ( $row = $db->get_row( $sql ) ) {
					if ( $i == $max ) {
						$tpl->result['dlemovie-categories'] .= '</tr><tr><td colspan="' . $max . '" style="padding-top:5px;"></td></tr><tr>';
						$i = 1;
					} else $i ++;
					$videocategory = $dlemovie->categoryInfo( $row['id'] );
						
					$tpl->load_template( 'dlemovie/block-category.tpl' );
					$tpl->set( '{table-width}', $width );
					$tpl->set( '{category-id}', $row['id'] );
					$tpl->set( '{category-link}', $videocategory['link'] );
					$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['category_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['category_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
					if ( @file_exists( ROOT_DIR . '/uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) ) {
						$tpl->set( '{preview}', ( empty( $row['preview'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/category.png' : $config['http_home_url'] . 'uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) );
					} else $tpl->set( '{preview}', $config['http_home_url'] . 'uploads/dlemovie/default/category.png' );
					$tpl->set( '{videos}', intval( $row['videos'] ) );
					$tpl->compile( 'dlemovie-categories' );
				}
				$_content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-categories'] . '</tr></table>';
			} else $_content .= $dlemovie->infoBox( $dlemovie->lang['not_categories'] );
		}
		
		if ( $count > $limit_topage ) {
			$pagelink = array( 'normal' => '?do=video&page={page}', 'short' => 'video/page-{page}.html' );
			if ( $page <= $total_pages and $page > 1 ) {
				$dlemovie->metatagTitle( $dlemovie->lang['text_page'] . ' №' . $page );
				$dlemovie->speedBar( $dlemovie->lang['text_page'] . ' №' . $page );
			}
			$tpl->load_template( 'navigation.tpl' );
			if ( $page > 1 ) {
				$tpl->set( '[prev-link]', '<a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page - 1 ) ) . '">' );
				$tpl->set( '[/prev-link]', '</a> ' );
			} else {
				$tpl->set( '[prev-link]', '<span>' );
				$tpl->set( '[/prev-link]', '</span>' );
			}
			$enpages_count = $total_pages;
			$pages = '';
			$cstart = $page;
			if ( $enpages_count <= 10 ) {
				for ( $j = 1; $j <= $enpages_count; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
			} else {
				$start = 1;
				$end = 10;
				$nav = '<span>...</span>';
				if ( $cstart > 0 ) {
					if ( $cstart > 6 ) {
						$start = $cstart - 4;
						$end = $start + 8;
						if ( $end >= $enpages_count ) {
							$start = $enpages_count - 9;
							$end = $enpages_count - 1;
							$nav = '';
						} else $nav = '<span>...</span>';
					}
				}
				if ( $start >= 2 ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, 1 ) . "\">1</a> <span>...</span> ";
				for ( $j = $start; $j <= $end; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
				if ( $cstart != $enpages_count ) $pages .= "$nav <a href=\"" . $dlemovie->parseUrlPage( $pagelink, $enpages_count ) . "\">$enpages_count</a> ";
				else $pages .= "<span>$enpages_count</span> ";
			}
			$tpl->set( '{pages}', $pages );
			if ( $page != $total_pages ) {
				$tpl->set( '[next-link]', ' <a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page + 1 ) ) . '">' );
				$tpl->set( '[/next-link]', '</a>' );
			} else {
				$tpl->set( '[next-link]', '<span>' );
				$tpl->set( '[/next-link]', '</span>' );
			}
			$tpl->compile( 'navigation' );
			$_content .= '<br />' . $tpl->result['navigation'];
		}
		break;
	case 'top' :
		$page = intval( $_REQUEST['page'] );
		$page = ( $page <= 0 ) ? 1 : $page;
		$i = 0;
	
		$toptype = $_REQUEST['type'];
		if ( $toptype != 'view' and $toptype != 'rating' and $toptype != 'new' ) $toptype = 'view';
		
		$_title = $dlemovie->lang['title_top'] . ' &raquo; ' . $dlemovie->lang['title_top'.$toptype];
		
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_top'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_top'.$toptype] );
		
		$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_top'], ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video&act=top&type=' . $toptype, 'video/top/' . $toptype . '/' ) : false ) );
		$dlemovie->speedBar( $dlemovie->lang['title_top'.$toptype], ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video&act=top&type=' . $toptype, 'video/top/' . $toptype . '/' ) : false ) );
		
		$limit_topage = $dlemovie->config['video_topage'];
		$max = ( integer ) $dlemovie->config['video_toline'];
		$limit = ( $page * $limit_topage ) - $limit_topage;
		if ( $toptype == 'view' ) $sort_sql = 'views DESC';
		elseif ( $toptype == 'new' ) $sort_sql = 'date DESC';
		else $sort_sql = 'rating DESC';
		$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_videos.approved = '1' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
		$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_videos WHERE approved = '1'" );
		
		$width = round( 100 / $max, 0 ) . '%';
		$count = $sql_total['count'];
		$total_pages = ceil( $count / $limit_topage );
		
		if ( $db->num_rows( $sql ) > 0 ) {
			$favorite = explode( ',', $member_id['dm_favorite_video'] );
			$tpl->result['dlemovie-videos'] = '';
			while ( $row = $db->get_row( $sql ) ) {
				if ( $i == $max ) {
					$tpl->result['dlemovie-videos'] .= '</tr><tr><td colspan="' . $max . '" class="dlemovie-content-break"></td></tr><tr>';
					$tpl->result['dlemovie-videos'] .= '</tr><tr><td colspan="' . $max . '" class="dlemovie-content-break"></td></tr><tr>';
					$i = 1;
				} else $i ++;
				$videocategory = $dlemovie->categoryInfo( $row['category'] );
				$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
	
				$tpl->load_template( 'dlemovie/block-video.tpl' );
				$tpl->set( '{table-width}', $width );
				$tpl->set( '{video-id}', $row['id'] );
				$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
				$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
				$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
				$tpl->set( '{category-id}', $row['category'] );
				$tpl->set( '{category-name}', $videocategory['title'] );
				$tpl->set( '{category-link}', $videocategory['link'] );
				$tpl->set( '{member-id}', $row['member'] );
				$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
				$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
				$tpl->set( '{views}', intval( $row['views'] ) );
				$tpl->set( '{rating}', intval( $row['rating'] ) );
				$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
					
				if ( $dlemovie->config['categories'] == 'yes' ) {
					$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' ) );
				} else {
					$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $encodetitle . '.html' ) );
				}
				if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
					$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
				} else {
					$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
				}
				if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
					$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
					if ( in_array( $row['id'], $favorite ) ) {
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
					$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
					} else {
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
					}
				} else {
					$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
					$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
					$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
				}
				if ( $row['category'] == 0 ) {
					$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
				} else {
					$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
				}
				if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
					$tpl->set( '{comments}', intval( $row['comments'] ) );
					$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
				} else {
					$tpl->set( '{comments}', '' );
					$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
				}
				
				$tpl->compile( 'dlemovie-videos' );
			}
			$_content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-videos'] . '</tr></table>';
		} else $_content .= $dlemovie->infoBox( $dlemovie->lang['not_videos'] );
		
		if ( $count > $limit_topage ) {
			$pagelink = array( 'normal' => '?do=video&act=top&type=' . $toptype . '&page={page}', 'short' => 'video/top/' . $toptype . '/page-{page}.html' );
			if ( $page <= $total_pages and $page > 1 ) {
				$dlemovie->metatagTitle( $dlemovie->lang['text_page'] . ' №' . $page );
				$dlemovie->speedBar( $dlemovie->lang['text_page'] . ' №' . $page );
			}
			$tpl->load_template( 'navigation.tpl' );
			if ( $page > 1 ) {
				$tpl->set( '[prev-link]', '<a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page - 1 ) ) . '">' );
				$tpl->set( '[/prev-link]', '</a> ' );
			} else {
				$tpl->set( '[prev-link]', '<span>' );
				$tpl->set( '[/prev-link]', '</span>' );
			}
			$enpages_count = $total_pages;
			$pages = '';
			$cstart = $page;
			if ( $enpages_count <= 10 ) {
				for ( $j = 1; $j <= $enpages_count; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
			} else {
				$start = 1;
				$end = 10;
				$nav = '<span>...</span>';
				if ( $cstart > 0 ) {
					if ( $cstart > 6 ) {
						$start = $cstart - 4;
						$end = $start + 8;
						if ( $end >= $enpages_count ) {
							$start = $enpages_count - 9;
							$end = $enpages_count - 1;
							$nav = '';
						} else $nav = '<span>...</span>';
					}
				}
				if ( $start >= 2 ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, 1 ) . "\">1</a> <span>...</span> ";
				for ( $j = $start; $j <= $end; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
				if ( $cstart != $enpages_count ) $pages .= "$nav <a href=\"" . $dlemovie->parseUrlPage( $pagelink, $enpages_count ) . "\">$enpages_count</a> ";
				else $pages .= "<span>$enpages_count</span> ";
			}
			$tpl->set( '{pages}', $pages );
			if ( $page != $total_pages ) {
				$tpl->set( '[next-link]', ' <a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page + 1 ) ) . '">' );
				$tpl->set( '[/next-link]', '</a>' );
			} else {
				$tpl->set( '[next-link]', '<span>' );
				$tpl->set( '[/next-link]', '</span>' );
			}
			$tpl->compile( 'navigation' );
			$_content .= '<br />' . $tpl->result['navigation'];
		}
		break;
	case 'search' :
		$tpl->load_template( 'dlemovie/search.tpl' );
		$tpl->set( '{search-text}', '' );
		$tpl->set_block( "'\\[search-result\\](.*?)\\[/search-result\\]'si", "" );
		
		if ( $dlemovie->config['categories'] == 'yes' ) {
			$tpl->set( '{search-types}', $dlemovie->makeSelectOptions( array( 'video' => $dlemovie->lang['title_search_video'], 'category' => $dlemovie->lang['title_search_category'] ), 'video' ) );
			$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "\\1" );
		} else {
			$tpl->set( '{search-types}', $dlemovie->makeSelectOptions( array( 'video' => $dlemovie->lang['title_search_video'] ), 'video' ) );
			$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "\\1" );
		}
		
		$tpl->compile( 'dlemovie-search-form' );
		
		$_title = $dlemovie->lang['title_search'];
		
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_search'] );
		
		$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_search'] );
		
		$_content .= '<form action="" method="post"><input type="hidden" name="do" value="video" /><input type="hidden" name="act" value="dosearch" /><input type="hidden" name="page" value="1" />' . $tpl->result['dlemovie-search-form'] . '</form>';
		break;
	case 'dosearch' :
		include_once ENGINE_DIR . '/classes/parse.class.php';
		$parse = new ParseFilter( );
		
		$search_text = $db->safesql( $parse->process( trim( urldecode( $_REQUEST['search'] ) ) ) );
		$search_orig = urlencode( $search_text );
		$search_type = $_REQUEST['type'];
		if ( $search_type != 'video' and $search_type != 'category' ) $search_type = 'video';
		
		$page = intval( $_REQUEST['page'] );
		$page = ( $page <= 0 ) ? 1 : $page;
		$i = 0;
	
		$tpl->load_template( 'dlemovie/search.tpl' );
		$tpl->set( '{search-text}', $search_text );
		$tpl->set_block( "'\\[search-result\\](.*?)\\[/search-result\\]'si", "\\1" );
		
		if ( $dlemovie->config['categories'] == 'yes' ) {
			$tpl->set( '{search-types}', $dlemovie->makeSelectOptions( array( 'video' => $dlemovie->lang['title_search_video'], 'category' => $dlemovie->lang['title_search_category'] ), $search_type ) );
			$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "\\1" );
		} else {
			$tpl->set( '{search-types}', $dlemovie->makeSelectOptions( array( 'video' => $dlemovie->lang['title_search_video'] ), 'video' ) );
			$tpl->set_block( "'\\[categories\\](.*?)\\[/categories\\]'si", "\\1" );
		}
		
		$tpl->compile( 'dlemovie-search-form' );
		
		if ( dle_strlen( $search_text, $config['charset'] ) > 2 ) {
			if ( $search_type == 'video' ) {
				$limit_topage = $dlemovie->config['video_topage'];
				$max = ( integer ) $dlemovie->config['video_toline'];
				$limit = ( $page * $limit_topage ) - $limit_topage;
				if ( $dlemovie->config['video_sort'] == 2 ) $sort_sql = 'title DESC';
				elseif ( $dlemovie->config['video_sort'] == 3 ) $sort_sql = 'date ASC';
				elseif ( $dlemovie->config['video_sort'] == 4 ) $sort_sql = 'date DESC';
				elseif ( $dlemovie->config['video_sort'] == 5 ) $sort_sql = 'views ASC';
				elseif ( $dlemovie->config['video_sort'] == 6 ) $sort_sql = 'views DESC';
				elseif ( $dlemovie->config['video_sort'] == 7 ) $sort_sql = 'rating ASC';
				elseif ( $dlemovie->config['video_sort'] == 8 ) $sort_sql = 'rating DESC';
				else $sort_sql = 'title ASC';
				$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_videos.approved = '1' AND " . PREFIX . "_dm_videos.title REGEXP '$search_text' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
				$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_videos WHERE approved = '1' AND title REGEXP '$search_text'" );
			} elseif ( $dlemovie->config['hometype'] == 'category' ) {
				$limit_topage = $dlemovie->config['category_topage'];
				$max = ( integer ) $dlemovie->config['category_toline'];
				$limit = ( $page * $limit_topage ) - $limit_topage;
				if ( $dlemovie->config['category_sort'] == 2 ) $sort_sql = 'title DESC';
				elseif ( $dlemovie->config['category_sort'] == 3 ) $sort_sql = 'videos ASC';
				elseif ( $dlemovie->config['category_sort'] == 4 ) $sort_sql = 'videos DESC';
				elseif ( $dlemovie->config['category_sort'] == 5 ) $sort_sql = 'posi ASC';
				elseif ( $dlemovie->config['category_sort'] == 6 ) $sort_sql = 'posi DESC';
				else $sort_sql = 'title ASC';
				$sql = $db->query( "SELECT id, name, title, preview, videos, previewup FROM " . PREFIX . "_dm_category WHERE title REGEXP '$search_text' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
				$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_category WHERE title REGEXP '$search_text'" );
			}
			
			$width = round( 100 / $max, 0 ) . '%';
			$count = $sql_total['count'];
			$total_pages = ceil( $count / $limit_topage );
			$__content = '';
			
			if ( $search_type == 'video' ) {
				if ( $db->num_rows( $sql ) > 0 ) {
					$favorite = explode( ',', $member_id['dm_favorite_video'] );
					$tpl->result['dlemovie-videos'] = '';
					while ( $row = $db->get_row( $sql ) ) {
						if ( $i == $max ) {
							$tpl->result['dlemovie-videos'] .= '</tr><tr><td colspan="' . $max . '" class="dlemovie-content-break"></td></tr><tr>';
							$i = 1;
						} else $i ++;
						$videocategory = $dlemovie->categoryInfo( $row['category'] );
						$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
						
						$tpl->load_template( 'dlemovie/block-video.tpl' );
						$tpl->set( '{table-width}', $width );
						$tpl->set( '{video-id}', $row['id'] );
						$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
						$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
						$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
						$tpl->set( '{category-id}', $row['category'] );
						$tpl->set( '{category-name}', $videocategory['title'] );
						$tpl->set( '{category-link}', $videocategory['link'] );
						$tpl->set( '{member-id}', $row['member'] );
						$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
						$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
						$tpl->set( '{views}', intval( $row['views'] ) );
						$tpl->set( '{rating}', intval( $row['rating'] ) );
						$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
						
						if ( $dlemovie->config['categories'] == 'yes' ) {
							$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' ) );
						} else {
							$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $encodetitle . '.html' ) );
						}
						if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
							$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
						} else {
							$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
						}
						if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
							$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
							if ( in_array( $row['id'], $favorite ) ) {
								$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
							} else {
								$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
								$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
							}
						} else {
							$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						}
						if ( $row['category'] == 0 ) {
							$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
						} else {
							$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
						}
						if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
							$tpl->set( '{comments}', intval( $row['comments'] ) );
							$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
						} else {
							$tpl->set( '{comments}', '' );
							$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
						}
						
						$tpl->compile( 'dlemovie-videos' );
					}
					$__content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-videos'] . '</tr></table>';
				} else $__content .= $dlemovie->infoBox( $dlemovie->lang['not_videos'] );
			} elseif ( $search_type == 'category' ) {
				if ( $db->num_rows( $sql ) > 0 ) {
					$tpl->result['dlemovie-categories'] = '';
					while ( $row = $db->get_row( $sql ) ) {
						if ( $i == $max ) {
							$tpl->result['dlemovie-categories'] .= '</tr><tr><td colspan="' . $max . '" style="padding-top:5px;"></td></tr><tr>';
							$i = 1;
						} else $i ++;
						$videocategory = $dlemovie->categoryInfo( $row['id'] );
							
						$tpl->load_template( 'dlemovie/block-category.tpl' );
						$tpl->set( '{table-width}', $width );
						$tpl->set( '{category-id}', $row['id'] );
						$tpl->set( '{category-link}', $videocategory['link'] );
						$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['category_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['category_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
						if ( @file_exists( ROOT_DIR . '/uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) ) {
							$tpl->set( '{preview}', ( empty( $row['preview'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/category.png' : $config['http_home_url'] . 'uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) );
						} else $tpl->set( '{preview}', $config['http_home_url'] . 'uploads/dlemovie/default/category.png' );
						$tpl->set( '{videos}', intval( $row['videos'] ) );
						$tpl->compile( 'dlemovie-categories' );
					}
					$__content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-categories'] . '</tr></table>';
				} else $__content .= $dlemovie->infoBox( $dlemovie->lang['not_categories'] );
			}
		} else {
			$__content .= $dlemovie->infoBox( $dlemovie->lang['search_strlen'], true );
		}
		
		$_title = $dlemovie->lang['title_search_short'] . ' &raquo; ' . $dlemovie->lang['title_search_'.$search_type];
		
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_search_short'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_search_'.$search_type] );
		
		$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_search_short'], $dlemovie->parseUrl( '?do=video&act=search', 'video/search/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_search_'.$search_type], ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video&act=dosearch&type=' . $search_type . '&search=' . $search_orig, 'video/search/' . $search_type . ',' . $search_orig . '/' ) : false ) );
		
		$_content .= '<form action="" method="post"><input type="hidden" name="do" value="video" /><input type="hidden" name="act" value="dosearch" /><input type="hidden" name="page" value="1" />' . $tpl->result['dlemovie-search-form'] . '</form>' . $__content;
		
		if ( $count > $limit_topage ) {
			$pagelink = array( 'normal' => '?do=video&act=dosearch&type=' . $search_type . '&search=' . $search_orig . '&page={page}', 'short' => 'video/search/' . $search_type . ',' . $search_orig . '/page-{page}.html' );
			if ( $page <= $total_pages and $page > 1 ) {
				$dlemovie->metatagTitle( $dlemovie->lang['text_page'] . ' №' . $page );
				$dlemovie->speedBar( $dlemovie->lang['text_page'] . ' №' . $page );
			}
			$tpl->load_template( 'navigation.tpl' );
			if ( $page > 1 ) {
				$tpl->set( '[prev-link]', '<a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page - 1 ) ) . '">' );
				$tpl->set( '[/prev-link]', '</a> ' );
			} else {
				$tpl->set( '[prev-link]', '<span>' );
				$tpl->set( '[/prev-link]', '</span>' );
			}
			$enpages_count = $total_pages;
			$pages = '';
			$cstart = $page;
			if ( $enpages_count <= 10 ) {
				for ( $j = 1; $j <= $enpages_count; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
			} else {
				$start = 1;
				$end = 10;
				$nav = '<span>...</span>';
				if ( $cstart > 0 ) {
					if ( $cstart > 6 ) {
						$start = $cstart - 4;
						$end = $start + 8;
						if ( $end >= $enpages_count ) {
							$start = $enpages_count - 9;
							$end = $enpages_count - 1;
							$nav = '';
						} else $nav = '<span>...</span>';
					}
				}
				if ( $start >= 2 ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, 1 ) . "\">1</a> <span>...</span> ";
				for ( $j = $start; $j <= $end; $j ++ ) {
					if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
					else $pages .= "<span>$j</span> ";
				}
				if ( $cstart != $enpages_count ) $pages .= "$nav <a href=\"" . $dlemovie->parseUrlPage( $pagelink, $enpages_count ) . "\">$enpages_count</a> ";
				else $pages .= "<span>$enpages_count</span> ";
			}
			$tpl->set( '{pages}', $pages );
			if ( $page != $total_pages ) {
				$tpl->set( '[next-link]', ' <a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page + 1 ) ) . '">' );
				$tpl->set( '[/next-link]', '</a>' );
			} else {
				$tpl->set( '[next-link]', '<span>' );
				$tpl->set( '[/next-link]', '</span>' );
			}
			$tpl->compile( 'navigation' );
			$_content .= '<br />' . $tpl->result['navigation'];
		}
		break;
	case 'category' :
		$name = $db->safesql( preg_replace( '#([^A-Z0-9-_.])#is', '', trim( $_REQUEST['name'] ) ) );
		$page = intval( $_REQUEST['page'] );
		$page = ( $page <= 0 ) ? 1 : $page;
		$i = 0;
		
		$category = $db->super_query( "SELECT id, title, descr, pagetitle, pagekeywords, pagedescription, parentid FROM " . PREFIX . "_dm_category WHERE name = '$name'" );
		if ( $category['id'] > 0 ) {
			if ( ! empty( $category['pagekeywords'] ) ) $dlemovie->metatagKeywords( htmlspecialchars( stripslashes( $category['pagekeywords'] ) ) );
			if ( ! empty( $category['pagedescription'] ) ) $dlemovie->metatagDescription( htmlspecialchars( stripslashes( $category['pagedescription'] ) ) );
			
			if ( empty( $category['pagetitle'] ) ) {
				$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
				$dlemovie->metatagTitle( stripslashes( $category['title'] ) );
			} else {
				$metatags['title'] = '';
				$dlemovie->metatagTitle( htmlspecialchars( stripslashes( $category['pagetitle'] ) ), true );
			}
			
			$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
			if ( $category['parentid'] < 1 ) {
				$dlemovie->speedBar( stripslashes( $category['title'] ), ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video&act=category&name=' . $name, 'video/' . $name . '/' ) : false ) );
			} else {
				$categorytitles = array_reverse( $dlemovie->categoryGetTitles( $category['id'] ) );
				$categoryend = end( $categorytitles );
				foreach ( $categorytitles as $categoryrow ) {
					if ( $categoryend['name'] == $categoryrow['name'] ) {
						$dlemovie->speedBar( $categoryrow['title'], ( ( $page > 1 ) ? $dlemovie->parseUrl( '?do=video&act=category&name=' . $categoryrow['name'], 'video/' . $categoryrow['name'] . '/' ) : false ) );
					} else {
						$dlemovie->speedBar( $categoryrow['title'], $dlemovie->parseUrl( '?do=video&act=category&name=' . $categoryrow['name'], 'video/' . $categoryrow['name'] . '/' ) );
					}
				}
			}
			
			$_title = stripslashes( $category['title'] );
			
			$limit_topage = $dlemovie->config['video_topage'];
			$max = ( integer ) $dlemovie->config['video_toline'];
			$limit = ( $page * $limit_topage ) - $limit_topage;
			if ( $dlemovie->config['video_sort'] == 2 ) $sort_sql = 'title DESC';
			elseif ( $dlemovie->config['video_sort'] == 3 ) $sort_sql = 'date ASC';
			elseif ( $dlemovie->config['video_sort'] == 4 ) $sort_sql = 'date DESC';
			elseif ( $dlemovie->config['video_sort'] == 5 ) $sort_sql = 'views ASC';
			elseif ( $dlemovie->config['video_sort'] == 6 ) $sort_sql = 'views DESC';
			elseif ( $dlemovie->config['video_sort'] == 7 ) $sort_sql = 'rating ASC';
			elseif ( $dlemovie->config['video_sort'] == 8 ) $sort_sql = 'rating DESC';
			else $sort_sql = 'title ASC';
			
			$sql_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_videos WHERE approved = '1' AND category = '$category[id]'" );
			$width = round( 100 / $max, 0 ) . '%';
			$count = $sql_total['count'];
			$total_pages = ceil( $count / $limit_topage );
			
			$tpl->result['dlemovie-categories'] = '';
			if ( $dlemovie->config['categories'] == 'yes' ) {
				$allowmulti = false;
				foreach ( $dlemovie->category as $temprow ) {
					if ( $temprow['parentid'] > 0 and $temprow['parentid'] == $category['id'] ) {
						$allowmulti = true;
						break;
					}
				}
				if ( $allowmulti ) {
					if ( $dlemovie->config['category_sort'] == 2 ) $category_sort_sql = 'title DESC';
					elseif ( $dlemovie->config['category_sort'] == 3 ) $category_sort_sql = 'videos ASC';
					elseif ( $dlemovie->config['category_sort'] == 4 ) $category_sort_sql = 'videos DESC';
					elseif ( $dlemovie->config['category_sort'] == 5 ) $category_sort_sql = 'posi ASC';
					elseif ( $dlemovie->config['category_sort'] == 6 ) $category_sort_sql = 'posi DESC';
					else $category_sort_sql = 'title ASC';
					$categorychild = $db->query( "SELECT id, name, title, preview, videos, previewup FROM " . PREFIX . "_dm_category WHERE parentid = '" . $category['id'] . "' ORDER BY {$category_sort_sql} LIMIT " . $limit . ',' . $limit_topage );
					$categorychild_total = $db->super_query( "SELECT COUNT(*) as count FROM " . PREFIX . "_dm_category WHERE parentid = '" . $category['id'] . "'" );
					$categorychild_total = $categorychild_total['count'];
					
					$limit_videos_max = $limit_topage - $db->num_rows( $categorychild );
					$limit_videos = ( $limit_videos_max != $limit_topage ) ? 0 : ( $page - 1 ) * $limit_topage - $categorychild_total;
					$limit = $limit_videos;
					$limit_topage = $limit_videos_max;
					
					if ( $categorychild_total > 0 ) {
						while ( $row = $db->get_row( $categorychild ) ) {
							if ( $i == $max ) {
								$tpl->result['dlemovie-categories'] .= '</tr><tr><td colspan="' . $max . '" style="padding-top:5px;"></td></tr><tr>';
								$i = 1;
							} else $i ++;
							$videocategory = $dlemovie->categoryInfo( $row['id'] );
						
							$tpl->load_template( 'dlemovie/block-category.tpl' );
							$tpl->set( '{table-width}', $width );
							$tpl->set( '{category-id}', $row['id'] );
							$tpl->set( '{category-link}', $videocategory['link'] );
							$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['category_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['category_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
							if ( @file_exists( ROOT_DIR . '/uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) ) {
								$tpl->set( '{preview}', ( empty( $row['preview'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/category.png' : $config['http_home_url'] . 'uploads/dlemovie/category/' . stripslashes( $row['preview'] ) ) );
							} else $tpl->set( '{preview}', $config['http_home_url'] . 'uploads/dlemovie/default/category.png' );
							$tpl->set( '{videos}', intval( $row['videos'] ) );
							$tpl->compile( 'dlemovie-categories' );
						}
					}
				}
			}
			$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_videos.approved = '1' AND category = '$category[id]' ORDER BY {$sort_sql} LIMIT " . $limit . ',' . $limit_topage );
			
			if ( $db->num_rows( $sql ) > 0 ) {
				$favorite = explode( ',', $member_id['dm_favorite_video'] );
				$tpl->result['dlemovie-videos'] = '';
				while ( $row = $db->get_row( $sql ) ) {
					if ( $i == $max ) {
						$tpl->result['dlemovie-videos'] .= '</tr><tr><td colspan="' . $max . '" class="dlemovie-content-break"></td></tr><tr>';
						$i = 1;
					} else $i ++;
					$videocategory = $dlemovie->categoryInfo( $row['category'] );
					$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
		
					$tpl->load_template( 'dlemovie/block-video.tpl' );
					$tpl->set( '{table-width}', $width );
					$tpl->set( '{video-id}', $row['id'] );
					$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
					$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
					$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
					$tpl->set( '{category-id}', $row['category'] );
					$tpl->set( '{category-name}', $videocategory['title'] );
					$tpl->set( '{category-link}', $videocategory['link'] );
					$tpl->set( '{member-id}', $row['member'] );
					$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
					$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
					$tpl->set( '{views}', intval( $row['views'] ) );
					$tpl->set( '{rating}', intval( $row['rating'] ) );
					$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
						
					if ( $dlemovie->config['categories'] == 'yes' ) {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					} else {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					}
					if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
					} else {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
					}
					if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
						if ( in_array( $row['id'], $favorite ) ) {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						} else {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
						}
					} else {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
					}
					if ( $row['category'] == 0 ) {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
					} else {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
					}
					if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
						$tpl->set( '{comments}', intval( $row['comments'] ) );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
					} else {
						$tpl->set( '{comments}', '' );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
					}
					
					$tpl->compile( 'dlemovie-videos' );
				}
				
				$category['descr'] = stripslashes( $category['descr'] );
				if ( ! empty( $category['descr'] ) and ( ( $dlemovie->config['category_descr_onlyfirstpage'] == 'yes' and $page == 1 ) or $dlemovie->config['category_descr_onlyfirstpage'] != 'yes' ) ) {
					$_content .= '<div class="dlemovie-category-info">' . $category['descr'] . '</div>';
				}
				
				$_content .= '<table width="100%"><tr>' . $tpl->result['dlemovie-categories'] . $tpl->result['dlemovie-videos'] . '</tr></table>';
			} else $_content .= $dlemovie->infoBox( $dlemovie->lang['not_videos'] );
			
			if ( $count > $limit_topage ) {
				$pagelink = array( 'normal' => '?do=video&act=category&name=' . $name . '&page={page}', 'short' => 'video/' . $name . '/page-{page}.html' );
				if ( $page <= $total_pages and $page > 1 ) {
					$dlemovie->metatagTitle( $dlemovie->lang['text_page'] . ' №' . $page );
					$dlemovie->speedBar( $dlemovie->lang['text_page'] . ' №' . $page );
				}
				$tpl->load_template( 'navigation.tpl' );
				if ( $page > 1 ) {
					$tpl->set( '[prev-link]', '<a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page - 1 ) ) . '">' );
					$tpl->set( '[/prev-link]', '</a> ' );
				} else {
					$tpl->set( '[prev-link]', '<span>' );
					$tpl->set( '[/prev-link]', '</span>' );
				}
				$enpages_count = $total_pages;
				$pages = '';
				$cstart = $page;
				if ( $enpages_count <= 10 ) {
					for ( $j = 1; $j <= $enpages_count; $j ++ ) {
						if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
						else $pages .= "<span>$j</span> ";
					}
				} else {
					$start = 1;
					$end = 10;
					$nav = '<span>...</span>';
					if ( $cstart > 0 ) {
						if ( $cstart > 6 ) {
							$start = $cstart - 4;
							$end = $start + 8;
							if ( $end >= $enpages_count ) {
								$start = $enpages_count - 9;
								$end = $enpages_count - 1;
								$nav = '';
							} else $nav = '<span>...</span>';
						}
					}
					if ( $start >= 2 ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, 1 ) . "\">1</a> <span>...</span> ";
					for ( $j = $start; $j <= $end; $j ++ ) {
						if ( $j != $cstart ) $pages .= "<a href=\"" . $dlemovie->parseUrlPage( $pagelink, $j ) . "\">$j</a> ";
						else $pages .= "<span>$j</span> ";
					}
					if ( $cstart != $enpages_count ) $pages .= "$nav <a href=\"" . $dlemovie->parseUrlPage( $pagelink, $enpages_count ) . "\">$enpages_count</a> ";
					else $pages .= "<span>$enpages_count</span> ";
				}
				$tpl->set( '{pages}', $pages );
				if ( $page != $total_pages ) {
					$tpl->set( '[next-link]', ' <a href="' . $dlemovie->parseUrlPage( $pagelink, ( $page + 1 ) ) . '">' );
					$tpl->set( '[/next-link]', '</a>' );
				} else {
					$tpl->set( '[next-link]', '<span>' );
					$tpl->set( '[/next-link]', '</span>' );
				}
				$tpl->compile( 'navigation' );
				$_content .= '<br />' . $tpl->result['navigation'];
			}
		} else {
			$_title = $dlemovie->lang['title_category_not'];
			$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
			$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
			$_content .= $dlemovie->infobox( $dlemovie->lang['text_category_not'], true );
		}
		break;
	case 'view' :
		$video_id = intval( $_REQUEST['video_id'] );
		$row = $db->super_query( "SELECT " . PREFIX . "_dm_videos.*, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.name WHERE " . PREFIX . "_dm_videos.approved = '1' AND " . PREFIX . "_dm_videos.id = '$video_id'" );
		if ( ! $row['id'] ) {
			$_title = $dlemovie->lang['title_video_not'];
			$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
			$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
			$_content .= $dlemovie->infobox( $dlemovie->lang['text_video_not'], true );
		} else {
			$db->query( "UPDATE " . PREFIX . "_dm_videos SET views = views + 1 WHERE id = '$video_id'" );
			if ( $row['category'] > 0 and $dlemovie->config['categories'] == 'yes' ) {				
				if ( empty( $dlemovie->category[$row['category']]['pagetitle'] ) ) {
					$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
					$dlemovie->metatagTitle( $dlemovie->category[$row['category']]['title'] );
				} else {
					$metatags['title'] = '';
					$dlemovie->metatagTitle( $dlemovie->category[$row['category']]['pagetitle'], true );
				}
				
				$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
				$dlemovie->speedBar( $dlemovie->category[$row['category']]['title'], $dlemovie->parseUrl( '?do=video&act=category&name=' . $dlemovie->category[$row['category']]['name'], 'video/' . $dlemovie->category[$row['category']]['name'] . '/' ) );
			}
			if ( ! empty( $row['descr'] ) ) {
				$metatags['description'] = htmlspecialchars( stripslashes( $row['descr'] ) );
				$metatags['keywords'] .= ', ' . htmlspecialchars( implode( ', ', explode( ' ', preg_replace( '#([^A-Z0-9А-Я\\s]+)#is' . ( ( strtolower( $config['charset'] ) == 'utf-8' ) ? 'u' : '' ), '', stripslashes( $row['title'] ) ) ) ) );
			}
			$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
			if ( $dlemovie->config['categories'] == 'yes' ) {
				$videocategory = $dlemovie->categoryInfo( $row['category'] );
				$ogurl = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $video_id, 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' );
			} else $ogurl = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $video_id, 'video/' . $row['id'] . '-' . $encodetitle . '.html' );
			$ogmetadata = $dlemovie->openGraphProtocol( $ogurl, htmlspecialchars( stripslashes( $row['title'] ) ), $config['http_home_url'] . 'uploads/dlemovie/' . $row['screen'], htmlspecialchars( stripslashes( $row['descr'] ) ) );
			
			$_title = stripslashes( $row['title'] );
			$dlemovie->metatagTitle( $row['title'] );
			$dlemovie->speedBar( stripslashes( $row['title'] ) );
			
			$related = $others = false;
			$favorite = explode( ',', $member_id['dm_favorite_video'] );
			$max = ( integer ) $dlemovie->config['video_toline'];
			$width = round( 100 / $max, 0 ) . '%';
			
			if ( $config['allow_cache'] != 'yes' ) {
				$config['allow_cache'] = 'yes';
				$dlemovie->dleconfig['allow_cache'] = 'yes';
				$revertcache = true;
			} else $revertcache = false;
			
			if ( $dlemovie->config['view_related'] == 'yes' ) {
				if ( $dlemovie->config['view_related_max'] < 1 ) $dlemovie->config['view_related_max'] = 3;
				$dlemovie_related = dle_cache( 'dlemovie-related-' . $row['id'] );
				if ( $dlemovie_related === false ) {
					$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE MATCH ( " . PREFIX . "_dm_videos.title ) AGAINST ( '" . $row['title'] . "' IN BOOLEAN MODE ) AND " . PREFIX . "_dm_videos.approved = '1' AND " . PREFIX . "_dm_videos.id != '$video_id' LIMIT 0," . $dlemovie->config['view_related_max'] );
					$favorite = explode( ',', $member_id['dm_favorite_video'] );
					$dlemovie_related = '';
					$i = 0;
					while ( $rows = $db->get_row( $sql ) ) {
						if ( $i == $max ) {
							$dlemovie_related .= '</tr><tr><td colspan="' . $max . '" style="padding-top:5px;"></td></tr><tr>';
							$i = 1;
						} else $i ++;
						$videocategory = $dlemovie->categoryInfo( $rows['category'] );
						$encodetitle = totranslit( ( dle_strlen( $rows['title'], $config['charset'] ) > 50 ? dle_substr( $rows['title'], 0, 50, $config['charset'] ) : $rows['title'] ) );
						
						$tpl->load_template( 'dlemovie/block-video.tpl' );
						$tpl->set( '{table-width}', $width );
						$tpl->set( '{video-id}', $rows['id'] );
						$tpl->set( '{title}', ( dle_strlen( stripslashes( $rows['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $rows['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $rows['title'] ) ) );
						$tpl->set( '{full-title}', stripslashes( $rows['title'] ) );
						$tpl->set( '{preview}', ( empty( $rows['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $rows['screen'] ) ) );
						$tpl->set( '{category-id}', $rows['category'] );
						$tpl->set( '{category-name}', $videocategory['title'] );
						$tpl->set( '{category-link}', $videocategory['link'] );
						$tpl->set( '{member-id}', $rows['member'] );
						$tpl->set( '{member}', stripslashes( $rows['member_name'] ) );
						$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $rows['date'] ) );
						$tpl->set( '{views}', intval( $rows['views'] ) );
						$tpl->set( '{rating}', intval( $rows['rating'] ) );
						$tpl->set( '{playtime}', $dlemovie->playTime( intval( $rows['playtime'] ) ) );
						
						if ( $dlemovie->config['categories'] == 'yes' ) {
							$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $rows['id'], 'video/' . $videocategory['name'] . '/' . $rows['id'] . '-' . $encodetitle . '.html' ) );
						} else {
							$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $rows['id'], 'video/' . $rows['id'] . '-' . $encodetitle . '.html' ) );
						}
						if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
							$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
						} else {
							$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
						}
						if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
							$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
							if ( in_array( $rows['id'], $favorite ) ) {
								$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
							} else {
								$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
								$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
							}
						} else {
							$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						}
						if ( $rows['category'] == 0 ) {
							$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
						} else {
							$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
						}
						if ( $rows['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
							$tpl->set( '{comments}', intval( $rows['comments'] ) );
							$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
						} else {
							$tpl->set( '{comments}', '' );
							$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
						}
						
						$tpl->compile( 'dlemovie-videos-related' );
					}
					$db->free( );
					$dlemovie_related .= $tpl->result['dlemovie-videos-related'];
					create_cache( 'dlemovie-related-' . $row['id'], $dlemovie_related );
					if ( ! empty( $dlemovie_related ) ) $related = true;
				} elseif ( ! empty( $dlemovie_related ) ) $related = true;
				else $related = false;
			}
			
			if ( $dlemovie->config['view_others'] == 'yes' ) {
				if ( $dlemovie->config['view_others_max'] < 1 ) $dlemovie->config['view_others_max'] = 3;
				$sql = $db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE " . PREFIX . "_dm_videos.approved = '1' AND " . PREFIX . "_dm_videos.id != '$video_id' AND " . PREFIX . "_dm_videos.member = '" . $row['member_name'] . "' ORDER BY RAND( ) LIMIT 0," . $dlemovie->config['view_others_max'] );
				$dlemovie_others = '';
				$i = 0;
				while ( $rows = $db->get_row( $sql ) ) {
					if ( $i == $max ) {
						$dlemovie_others .= '</tr><tr><td colspan="' . $max . '" style="padding-top:5px;"></td></tr><tr>';
						$i = 1;
					} else $i ++;
					$videocategory = $dlemovie->categoryInfo( $rows['category'] );
					$encodetitle = totranslit( ( dle_strlen( $rows['title'], $config['charset'] ) > 50 ? dle_substr( $rows['title'], 0, 50, $config['charset'] ) : $rows['title'] ) );
					
					$tpl->load_template( 'dlemovie/block-video.tpl' );
					$tpl->set( '{table-width}', $width );
					$tpl->set( '{video-id}', $rows['id'] );
					$tpl->set( '{title}', ( dle_strlen( stripslashes( $rows['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $rows['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $rows['title'] ) ) );
					$tpl->set( '{full-title}', stripslashes( $rows['title'] ) );
					$tpl->set( '{preview}', ( empty( $rows['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $rows['screen'] ) ) );
					$tpl->set( '{category-id}', $rows['category'] );
					$tpl->set( '{category-name}', $videocategory['title'] );
					$tpl->set( '{category-link}', $videocategory['link'] );
					$tpl->set( '{member-id}', $rows['member'] );
					$tpl->set( '{member}', stripslashes( $rows['member_name'] ) );
					$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $rows['date'] ) );
					$tpl->set( '{views}', intval( $rows['views'] ) );
					$tpl->set( '{rating}', intval( $rows['rating'] ) );
					$tpl->set( '{playtime}', $dlemovie->playTime( intval( $rows['playtime'] ) ) );
						
					if ( $dlemovie->config['categories'] == 'yes' ) {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $rows['id'], 'video/' . $videocategory['name'] . '/' . $rows['id'] . '-' . $encodetitle . '.html' ) );
					} else {
						$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $rows['id'], 'video/' . $rows['id'] . '-' . $encodetitle . '.html' ) );
					}
					if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
					} else {
						$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
					}
					if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
						if ( in_array( $rows['id'], $favorite ) ) {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						} else {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
						}
					} else {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
					}
					if ( $rows['category'] == 0 ) {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
					} else {
						$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
					}
					if ( $rows['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
						$tpl->set( '{comments}', intval( $rows['comments'] ) );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
					} else {
						$tpl->set( '{comments}', '' );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
					}
					
					$tpl->compile( 'dlemovie-videos-others' );
				}
				$db->free( );
				$dlemovie_others .= $tpl->result['dlemovie-videos-others'];
				if ( ! empty( $dlemovie_others ) ) $others = true;
			}
			if ( $revertcache ) {
				$config['allow_cache'] = 'no';
				$dlemovie->dleconfig['allow_cache'] = 'no';
			}
			
			$videocategory = $dlemovie->categoryInfo( $row['category'] );
			$videocomments = $dlemovie->commentsView( $video_id, stripslashes( $row['title'] ), $row['category'] );
			if ( $user_group[$group]['dm_add_comment'] == 1 ) $videocommentsadd = $dlemovie->commentsAddForm( $video_id );
			else $videocommentsadd = $dlemovie->infobox( $dlemovie->lang['comment_add_not_alowed'], false );
			$videocode = $dlemovie->playerShow( $row['video'], $row['provider'] );
			
			$tpl->load_template( 'dlemovie/viewvideo.tpl' );
			$tpl->set( '{video-id}', $video_id );
			$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
			$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
			$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
			$tpl->set( '{category-id}', $row['category'] );
			$tpl->set( '{category-name}', $videocategory['title'] );
			$tpl->set( '{category-link}', $videocategory['link'] );
			$tpl->set( '{member-id}', $row['member'] );
			$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
			$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
			$tpl->set( '{views}', intval( $row['views'] ) + 1 );
			$tpl->set( '{rating}', intval( $row['rating'] ) );
			$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
			$tpl->set( '{video-code}', $videocode );
			$tpl->set( '{link-edit}', $config['http_home_url'] . $config['admin_path'] . '?mod=dlemovie&act=videos&doact=edit&id=' . $row['id'] );
			
			$tpl->set_block( "'\\[edit\\](.*?)\\[/edit\\]'si", ( ( ( $user_group[$group]['dm_videos_personal_edit'] == 1 and $is_logged and $row['member'] == $member_id['name'] ) or ( $user_group[$group]['dm_videos_all_edit'] == 1 and $is_logged ) ) ? '\\1' : '' ) );
			$tpl->set_block( "'\\[delete\\](.*?)\\[/delete\\]'si", ( ( ( $user_group[$group]['dm_videos_personal_delete'] == 1 and $is_logged and $row['member'] == $member_id['name'] ) or ( $user_group[$group]['dm_videos_all_delete'] == 1 and $is_logged ) ) ? '\\1' : '' ) );
			
			if ( $group == 5 ) $is_like = $db->super_query( "SELECT id FROM " . PREFIX . "_dm_ratings WHERE type = 'video' AND go_id = '$video_id' AND member_ip = '" . $db->safesql( $_SERVER['REMOTE_ADDR'] ) . "'" );
			else $is_like = $db->super_query( "SELECT id FROM " . PREFIX . "_dm_ratings WHERE type = 'video' AND go_id = '$video_id' AND member_id = '$member_id[user_id]'" );
			$tpl->set( '{like-text}', ( ( $is_like['id'] > 0 ) ? $dlemovie->lang['video_like_not'] : $dlemovie->lang['video_like'] ) );
			
			$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
			if ( $dlemovie->config['categories'] == 'yes' ) {
				$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $video_id, 'video/' . $videocategory['name'] . '/' . $video_id . '-' . $encodetitle . '.html' ) );
			} else {
				$tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $video_id, 'video/' . $video_id . '-' . $encodetitle . '.html' ) );
			}
			if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) {
				$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
			} else {
				$tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
			}
			if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
				$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
				if ( in_array( $row['id'], $favorite ) ) {
					$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
					$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
				} else {
					$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
					$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
				}
			} else {
				$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
				$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
				$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
			}
			if ( $row['category'] == 0 ) {
				$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
			} else {
				$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
			}
			if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
				$tpl->set( '{comments}', intval( $row['comments'] ) );
				$tpl->set( '{comments-list}', $videocomments );
				$tpl->set( '{comments-add}', $videocommentsadd );
				$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
			} else {
				$tpl->set( '{comments}', '' );
				$tpl->set( '{comments-list}', '' );
				$tpl->set( '{comments-add}', '' );
				$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
			}
			if ( ! empty( $row['descr'] ) and $dlemovie->config['video_descr'] == 'yes' ) {
				$tpl->set( '{description}', stripslashes( $row['descr'] ) );
				$tpl->set_block( "'\\[description\\](.*?)\\[/description\\]'si", '\\1' );
			} else {
				$tpl->set( '{description}', '' );
				$tpl->set_block( "'\\[description\\](.*?)\\[/description\\]'si", '' );
			}
			if ( $dlemovie->config['video_code'] == 'yes' ) {
				$tpl->set( '{video-code-html}', htmlspecialchars( str_replace( array( "\t", "\r", "\n" ), '', $videocode ) ) );
				$tpl->set_block( "'\\[video-code\\](.*?)\\[/video-code\\]'si", '\\1' );
			} else {
				$tpl->set( '{video-code-html}', '' );
				$tpl->set_block( "'\\[video-code\\](.*?)\\[/video-code\\]'si", '' );
			}
			if ( $related ) {
				$tpl->set( '{related}', '<table width="100%"><tr>' . $dlemovie_related . '</tr></table>' );
				$tpl->set_block( "'\\[related\\](.*?)\\[/related\\]'si", '\\1' );
				$tpl->set_block( "'\\[not-related\\](.*?)\\[/not-related\\]'si", '' );
			} else {
				$tpl->set( '{related}', '' );
				$tpl->set_block( "'\\[related\\](.*?)\\[/related\\]'si", '' );
				$tpl->set_block( "'\\[not-related\\](.*?)\\[/not-related\\]'si", '\\1' );
			}
			if ( $others ) {
				$tpl->set( '{others}', '<table width="100%"><tr>' . $dlemovie_others . '</tr></table>' );
				$tpl->set_block( "'\\[others\\](.*?)\\[/others\\]'si", '\\1' );
				$tpl->set_block( "'\\[not-others\\](.*?)\\[/not-others\\]'si", '' );
			} else {
				$tpl->set( '{others}', '' );
				$tpl->set_block( "'\\[others\\](.*?)\\[/others\\]'si", '' );
				$tpl->set_block( "'\\[not-others\\](.*?)\\[/not-others\\]'si", '\\1' );
			}
			if ( $related and $others ) {
				$tpl->set_block( "'\\[related-and-others\\](.*?)\\[/related-and-others\\]'si", '\\1' );
				$tpl->set_block( "'\\[not-related-and-others\\](.*?)\\[/not-related-and-others\\]'si", '' );
			} else {
				$tpl->set_block( "'\\[related-and-others\\](.*?)\\[/related-and-others\\]'si", '' );
				$tpl->set_block( "'\\[not-related-and-others\\](.*?)\\[/not-related-and-others\\]'si", '\\1' );
			}
			if ( $related or $others ) {
				$tpl->set_block( "'\\[related-or-others\\](.*?)\\[/related-or-others\\]'si", '\\1' );
				$tpl->set_block( "'\\[not-related-or-others\\](.*?)\\[/not-related-or-others\\]'si", '' );
			} else {
				$tpl->set_block( "'\\[related-or-others\\](.*?)\\[/related-or-others\\]'si", '' );
				$tpl->set_block( "'\\[not-related-or-others\\](.*?)\\[/not-related-or-others\\]'si", '\\1' );
			}
			
			$tpl->compile( 'dlemovie-viewvideo' );
			$jslang = '
			<script type="text/javascript">
			var dlemovie_videosp_o = \'' . $dlemovie->lang['video_spoiler_o'] . '\',
			dlemovie_videosp_c = \'' . $dlemovie->lang['video_spoiler_c'] . '\',
			DleMovieLanguageVideoDelete = \'' . $dlemovie->lang['video_delete'] . '\',
			DleMovieLanguageVideoDeleteTitle = \'' . $dlemovie->lang['video_delete_title'] . '\',
			DleMovieLanguageVideoEditCancel = \'' . $dlemovie->lang['video_edit_cancel'] . '\',
			DleMovieLanguageVideoEditSave = \'' . $dlemovie->lang['video_edit_save'] . '\',
			DleMovieLanguageVideoEditTitle = \'' . $dlemovie->lang['video_edit_title'] . '\';
			</script>';
			$_content .= $jslang . $tpl->result['dlemovie-viewvideo'];
		}
		break;
	case 'upload' :
		$_title = $dlemovie->lang['title_upload'];
		
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_upload'] );
		
		$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_upload'] );
		
		$serviceslist = array( );
		foreach ( $dlemovie->providers as $id => $name ) {
			$option = $id . '_allow';
			if ( $dlemovie->config[$option] == 'yes' ) $serviceslist[] = $name;
		}
	
		if ( $group != 5 and $user_group[$group]['dm_upload_url'] == 1 ) {
			$tpl->load_template( 'dlemovie/upload.tpl' );
			$tpl->set( '{services}', ( ( count( $serviceslist ) > 0 ) ? implode( ', ', $serviceslist ) : '...' ) );
			if ( $dlemovie->config['categories'] == 'yes' ) {
				$tpl->set( '{category-list}', $dlemovie->categoryGetList( $dlemovie->category, 0, 0, true ) );
				$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
			} else {
				$tpl->set( '{category-list}', '' );
				$tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
			}
			$tpl->compile( 'dlemovie-upload' );
			$_content .= $tpl->result['dlemovie-upload'];
		} else $_content .= $dlemovie->infobox( $dlemovie->lang['upload_not_allow'], true );
		break;
	case 'doupload' :
		$_title = $dlemovie->lang['title_upload'];
		
		$dlemovie->metatagTitle( $dlemovie->config['mainname'] );
		$dlemovie->metatagTitle( $dlemovie->lang['title_upload'] );
		
		$dlemovie->speedBar( $dlemovie->config['mainname'], $dlemovie->parseUrl( '?do=video', 'video/' ) );
		$dlemovie->speedBar( $dlemovie->lang['title_upload'] );
	
		include_once ENGINE_DIR . '/classes/parse.class.php';
		$parse = new ParseFilter( );
		
		$type = 'remote'; // $_REQUEST['type'];
		if ( $type == 'remote' ) {
			$link = $parse->process( trim( $_POST['link'] ) );
			$title = $db->safesql( $parse->process( trim( $_POST['title'] ) ) );
			$descr = $db->safesql( $parse->process( str_replace( "\n", "<br />", trim( $_POST['descr'] ) ) ) );
			$category = intval( $_POST['category'] );
			$comments = ( intval( $_POST['comments'] ) == 1 ) ? 1 : 0;
			$moderate = ( $user_group[$group]['dm_moderate'] == 1 ) ? 0 : 1;
			$datetime = time( );
			
			if ( $dlemovie->config['categories'] != 'yes' ) $category = 0;
			if ( empty( $link ) ) $_content .= $dlemovie->infobox( $dlemovie->lang['upload_empty_link'], true );
			elseif ( $dlemovie->config['categories'] == 'yes' and $category <= 0 ) $_content .= $dlemovie->infobox( $dlemovie->lang['upload_empty_category'], true );
			else {
				$clip = array( );
				if ( $dlemovie->isVideoUrl( $link, $clip ) ) {
					$provider = $clip['provider'];
					$video = $dlemovie->videoImport( $clip['videoid'], $clip['provider'] );
					if ( $video !== false ) {
						if ( ! empty( $video['extra-provider'] ) ) {
							$provider = $clip['provider'] = $video['extra-provider'];
							$clip['videoid'] = $video['extra-id'];
						}
						$title = empty( $title ) ? $db->safesql( $parse->process( $video['title'] ) ) : $title;
						$descr = empty( $descr ) ? $db->safesql( $parse->process( $video['descr'] ) ) : $descr;
						$screen = ( ! empty( $video['screen']['url'] ) ) ? $dlemovie->screenSave( $video['screen']['url'], $video['screen']['width'] ) : '';
						$videoid = ( ! empty( $clip['specid'] ) ) ? $clip['specid'] : $clip['videoid'];
						$videoid = empty( $video['videoid'] ) ? $videoid : $video['videoid'];
						$db->query( "INSERT INTO " . PREFIX . "_dm_videos ( title, descr, video, provider, screen, playtime, category, member, date, allowcomm, approved ) VALUES ( '$title', '$descr', '$videoid', '$provider', '$screen', '$video[duration]', '$category', '$member_id[name]', '$datetime', '$comments', '$moderate' )" );
						$unicalid = $db->insert_id( );
						if ( $dlemovie->config['categories'] == 'yes' and $moderate == 1 ) {
							if ( $dlemovie->category[$category]['previewup'] == 1 ) $db->query( "UPDATE " . PREFIX . "_dm_category SET videos = videos + 1, preview = '../$screen' WHERE id = '$category'" );
							else $db->query( "UPDATE " . PREFIX . "_dm_category SET videos = videos + 1 WHERE id = '$category'" );
							$dlemovie->cacheClear( 'category' );
						}
						$title = stripslashes( $title );
						$encodetitle = totranslit( ( dle_strlen( $title, $config['charset'] ) > 50 ? dle_substr( $title, 0, 50, $config['charset'] ) : $title ) );
						if ( $dlemovie->config['categories'] == 'yes' ) $videolink = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $unicalid, 'video/' . $dlemovie->category[$category]['name'] . '/' . $unicalid . '-' . $encodetitle . '.html' );
						else $videolink = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $unicalid, 'video/' . $unicalid . '-' . $encodetitle . '.html' );
						if ( $moderate ) $_content .= $dlemovie->infobox( str_replace( array( '{title}', '{link}' ), array( $title, $videolink ), $dlemovie->lang['upload_ok_normal'] ), false );
						else $_content .= $dlemovie->infobox( str_replace( '{title}', $title, $dlemovie->lang['upload_ok_moderate'] ), false );
					} else $_content .= $dlemovie->infobox( $dlemovie->lang['upload_not_uploaded'], true );
				} else $_content .= $dlemovie->infobox( $dlemovie->lang['upload_not_uploaded'], true );
			}
		} else die( 'Method is not allowed.' );
		break;
}

if ( ! $_offline ) {
	$tpl->load_template( 'dlemovie/main.tpl' );
	$tpl->set( '{description}', $_title );
	$tpl->set( '{content}', $_content . $dlemovie->incCssAndJs( false, true ) );
	$tpl->compile( 'content' );
    if ( substr_count( $tpl->result['content'], '{custom' ) > 0 ) {
        $tpl->result['content'] = preg_replace( "#\\{custom category=['\"](.+?)['\"] template=['\"](.+?)['\"] aviable=['\"](.+?)['\"] from=['\"](.+?)['\"] limit=['\"](.+?)['\"] cache=['\"](.+?)['\"]\\}#ies", "custom_print('\\1', '\\2', '\\3', '\\4', '\\5', '\\6', 'video')", $tpl->result['content'] );
    }
	$tpl->result['content'] .= "\n\n";
}
?>