
CREATE TABLE IF NOT EXISTS `db_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL COMMENT 'Название поля',
  `un_name` varchar(50) NOT NULL COMMENT 'ЧПУ название доп. поля',
  `note` text NOT NULL COMMENT 'Примечание (посяснение) поля для заполняющего',
  `sectionid` varchar(255) NOT NULL COMMENT 'id категорий, в которых выводить данное поле',
  `display` enum('0','1') NOT NULL DEFAULT '1' COMMENT 'Выводить или нет данное поле (активность)',
  `posi` int(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Позиция вывода поля',
  `option_values` text NOT NULL COMMENT 'Значения в поле (из которых выбираются данные)',
  `default_values` text NOT NULL COMMENT 'Значения в поле по умолчанию',
  `units` varchar(7) DEFAULT NULL,
  `width` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ширина поля',
  `height` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'высота поля',
  `length` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'длина поля',
  `addition` varchar(255) NOT NULL COMMENT 'Дополнения к полю (css, js)',
  `insearch` enum('0','1') NOT NULL DEFAULT '1' COMMENT 'Выводить поле в поиске',
  `html_type` varchar(30) NOT NULL COMMENT 'HTML тип поля (пока не нужно)',
  `input_limit` enum('0','1') NOT NULL DEFAULT '1' COMMENT 'Обязательность и ограничения (проверка через рег. выражения)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_name` (`un_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED  AUTO_INCREMENT=305 ;

INSERT INTO `db_fields` (`id`, `name`, `un_name`, `note`, `sectionid`, `display`, `posi`, `option_values`, `default_values`, `units`, `width`, `height`, `length`, `addition`, `insearch`, `html_type`, `input_limit`) VALUES
(105, 'Производительность', 'proizvoditelnost_myasorubki', 'Количество мяса, которое может провернуть мясорубка за одну минуту. Производительность мясорубки зависит от мощности ее двигателя. Приборы с мощностью 1000 Вт обычно способны перекрутить от 0.8 до 1.3 кг мяса в минуту.', '37', '1', 1, '0.4|5.0', '', 'кг/мин', 0, 0, 0, '', '1', 'floatnum', '0'),
(106, 'Номинальная мощность мясорубки', 'moshhnost_myasorubki', 'Номинальная мощность - это мощность, с которой двигатель работает в стандартном режиме. Как правило, все мясорубки имеют запас мощности для перемалывания жил и хрящей - при этом двигатель начинает работать на предельной мощности (допустимо лишь кратковременное использование такого режима).', '37', '1', 1, '105|1100', '', 'Вт', 0, 0, 0, '', '1', 'number', '0'),
(107, 'Система реверса', 'revers_u_myasorubki', 'Наличие реверса - системы, позволяющей проворачивать шнек мясорубки в обратном направлении. Шнек - это спираль, осуществляющая прокрутку фарша. Функция реверса позволяет избавиться от жил, намотавшихся на шнек и затрудняющих работу мясорубки.', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(108, 'Соковыжималка', 'sokovyzhimalka_v_myasorubke', 'Наличие в комплекте насадки для получения сока из цитрусовых. Такая насадка для мясорубки является скорее приятным дополнением. Но если у вас нет кухонного комбайна или отдельной соковыжималки, вероятно, эта насадка для вас не будет лишней. Насадки-соковыжималки разделяют на шнековые и насадки цитрус-пресс.', '37', '1', 1, 'otsutstvuet|Отсутствует\r\ntsitrus-press|Цитрус-пресс\r\ntsitrus-press i shnekovaya|Цитрус-пресс и шнековая\r\nshnekovaya|Шнековая', '', '', 0, 0, 0, '', '1', 'select', '0'),
(109, 'Насадка-тёрка', 'nasadka_tyorka_v_myasorubke', 'Наличие в комплекте насадки-терки. Использование этой насадки дает возможность быстро и не прилагая усилий натереть овощи и другие продукты. Как правило, эта насадка представляет собой круглый цилиндр со множеством мелких отверстий (как в обычной терке).', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(110, 'Насадка для кеббе', 'kebbe_v_myasorubke', 'Наличие специальной насадки для приготовления полуфабриката для кеббе. Кеббе - это блюдо, имеющее вид полых сосисок (трубочек) из мяса, которые фаршируются и затем обжариваются.', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(111, 'Насадка для колбас', 'nasadka_dlya_kolbas_v_myasorubke', 'Наличие в комплекте насадки для приготовления домашних колбасок. К узкой горловине такой насадки присоединяют натуральную оболочку (или ее альтернативу - то, в чем вы будете хранить домашнюю колбасу) и включают агрегат.', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(112, 'Насадка для шинковки', 'shinkovki_v_myasorubke', '', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(113, 'Защита двигателя от перегрузки', 'zashhita_ot_peregruzki_myasorubki', 'Наличие специального предохранителя, защищающего электродвигатель мясорубки от перегрева и выхода из строя из-за перегрузки (например, в случае попадания кости).', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(114, 'Отсек для хранения насадок', 'otsek_xraneniya_myasorubki', 'Наличие специального отсека на корпусе мясорубки для хранения насадок. В зависимости от модели в таком отсеке можно хранить все насадки и аксессуары мясорубки или только некоторые из них.', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(115, 'Перфорированный диск для фарша в мясорубке', 'perf_disk_v_myasorubke', '', '37', '1', 1, 'yes|Да\r\nno|Нет', '', '', 0, 0, 0, '', '1', 'radio', '0'),
(116, 'Максимальная высота посуды', 'vysota_posudy_myasorubki', 'Расстояние от основания корпуса до головки мясорубки (выходного отверстия). Чем больше это расстояние, тем более высокую посуду можно использовать для сбора фарша. Как правило, высота от рабочей поверхности колеблется в диапазоне от 11 до 14 см.', '37', '1', 1, '100|100\r\n110|110\r\n120|120\r\n140|140\r\n150|150\r\n160|160', '', 'мм', 0, 0, 0, '', '1', 'select', '0');
